import { StarXpandCommand } from "star-io10-web";

export class LabelSample01_For203dpiAnd300dpi_TamperProofLabel_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        // Change the printable area setting for this layout according to the printer resolution.
        // 72.0 for 203dpi, 48.7 for 300dpi
        .settingPrintableArea(72.0)
        //.settingPrintableArea(48.7)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
            .styleBold(true)
            .styleMagnification(
              new StarXpandCommand.MagnificationParameter(4, 4),
            )
            .actionPrintText("SEALED\n")
            .actionPrintText("FRESH\n")
            .styleBold(false)
            .styleMagnification(
              new StarXpandCommand.MagnificationParameter(3, 3),
            )
            .actionPrintText("for Safety\n")
            .actionPrintImage(
              new StarXpandCommand.Printer.ImageParameter(
                "tamper_proof_label_checked.png",
                100,
              ),
            )
            .styleBold(true)
            .actionPrintText("................\n")
            .styleBold(false)
            .actionPrintText("${remarks}\n")
            .actionPrintQRCode(
              new StarXpandCommand.Printer.QRCodeParameter("${store_url}")
                .setCellSize(8)
                .setLevel(StarXpandCommand.Printer.QRCodeLevel.Q)
                .setModel(StarXpandCommand.Printer.QRCodeModel.Model2),
            )
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );

    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "remarks" : "Scan to leave\\na review",
    "store_url" : "http://starmicronics.com/"
}`,
    );
  }
}
